---
title: Cloud Connector (beta) · Cloudflare Rules docs
description: "Cloud Connector (beta) allows you to route matching incoming
  traffic from your website to a public cloud provider that you define:
  Cloudflare R2 object storage or an external provider such as AWS, Google
  Cloud, and Azure. With Cloud Connector you can make Cloudflare the control
  center for your web traffic, including traffic served from public cloud
  providers, without having to configure additional rules."
lastUpdated: 2025-10-06T10:46:53.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/rules/cloud-connector/
  md: https://developers.cloudflare.com/rules/cloud-connector/index.md
---

Cloud Connector (beta) allows you to route matching incoming traffic from your website to a public cloud provider that you define: [Cloudflare R2](https://developers.cloudflare.com/r2/) object storage or an external provider such as AWS, Google Cloud, and Azure. With Cloud Connector you can make Cloudflare the control center for your web traffic, including traffic served from public cloud providers, without having to configure additional rules.

Note

Cloud Connector requires that you [proxy the DNS records](https://developers.cloudflare.com/dns/proxy-status/) of your domain (or subdomain) through Cloudflare.

## How it works

First, you configure a Cloud Connector rule that specifies:

* The cloud provider and a supported cloud service that will accept traffic.
* The traffic that will be routed to that cloud service.

Then, Cloudflare will create the [necessary configurations](#applied-configurations) so that the content is accessible for requests matching your Cloud Connector rule. Your object storage bucket should be public for Cloud Connector to work.

Cloud Connector rules are evaluated last in the request evaluation workflow. When there is a rule match and you have other rules changing the same settings, the Cloud Connector rule will win over other rules.

## Applied configurations

Cloud Connector will perform the following configurations automatically, depending on the cloud provider:

* Modify the `Host` header.
* Adjust SSL/TLS for bucket-related traffic ([AWS S3 website endpoints](https://developers.cloudflare.com/rules/cloud-connector/providers/#ssl-connections-to-aws-s3-endpoints) only).

Additional configurations you may need

Cloud Connector will not apply any of the following configurations:

* **Cache content served from storage bucket**: To define custom cache behavior — like when to cache returned objects and for [how long](https://developers.cloudflare.com/cache/how-to/cache-rules/settings/#edge-ttl) — you will need to create a [cache rule](https://developers.cloudflare.com/cache/how-to/cache-rules/). For an example rule configuration, refer to [Cache Level (Cache Everything)](https://developers.cloudflare.com/cache/how-to/cache-rules/examples/cache-everything/).

* **Create URL rewrites**: To adjust the URL structure from what your website visitors use to obtain a resource and the folder structure being used in the storage bucket, you will need to create a [URL rewrite](https://developers.cloudflare.com/rules/transform/url-rewrite/). For example, you could create a URL rewrite to remove the `/files` prefix from URI paths before routing the request to your object storage bucket. For an example configuration, refer to [Rewrite path for object storage bucket](https://developers.cloudflare.com/rules/transform/examples/rewrite-path-object-storage/).

## Availability

Cloud Connector is available in beta to all customers. The maximum number of rules depends on your Cloudflare plan:

| | Free | Pro | Business | Enterprise |
| - | - | - | - | - |
| Availability | Yes | Yes | Yes | Yes |
| Number of rules | 10 | 25 | 50 | 300 |
