---
title: FAQ · Cloudflare Hyperdrive docs
description: Below you will find answers to our most commonly asked questions
  regarding Hyperdrive.
lastUpdated: 2025-04-24T15:01:18.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/hyperdrive/reference/faq/
  md: https://developers.cloudflare.com/hyperdrive/reference/faq/index.md
---

Below you will find answers to our most commonly asked questions regarding Hyperdrive.

## Connectivity

### Does Hyperdrive use specific IP addresses to connect to my database?

Hyperdrive connects to your database using [Cloudflare's IP address ranges](https://www.cloudflare.com/ips/). These are shared by all Hyperdrive configurations and other Cloudflare products.

You can use this to configure restrictions in your database firewall to restrict the IP addresses that can access your database.

### Does Hyperdrive support connecting to D1 databases?

Hyperdrive does not support [D1](https://developers.cloudflare.com/d1) because D1 provides fast connectivity from Workers by design.

Hyperdrive is designed to speed up connectivity to traditional, regional SQL databases such as PostgreSQL. These databases are typically accessed using database drivers that communicate over TCP/IP. Unlike D1, creating a secure database connection to a traditional SQL database involves multiple round trips between the client (your Worker) and your database server. See [How Hyperdrive works](https://developers.cloudflare.com/hyperdrive/configuration/how-hyperdrive-works/) for more detail on why round trips are needed and how Hyperdrive solves this.

D1 does not require round trips to create database connections. D1 is designed to be performant for access from Workers by default, without needing Hyperdrive.

## Pricing

### Does Hyperdrive charge for data transfer / egress?

No.

### Is Hyperdrive available on the [Workers Free](https://developers.cloudflare.com/workers/platform/pricing/#workers) plan?

Yes. Refer to [pricing](https://developers.cloudflare.com/hyperdrive/platform/pricing/).

### Does Hyperdrive charge for additional compute?

Hyperdrive itself does not charge for compute (CPU) or processing (wall clock) time. Workers querying Hyperdrive and computing results: for example, serializing results into JSON and/or issuing queries, are billed per [Workers pricing](https://developers.cloudflare.com/workers/platform/pricing/#workers).

## Limits

### Are there any limits to Hyperdrive?

Refer to the published [limits](https://developers.cloudflare.com/hyperdrive/platform/limits/) documentation.
