---
title: Troubleshooting · Cloudflare One docs
description: Review common troubleshooting scenarios for Cloudflare Zero Trust.
lastUpdated: 2025-10-24T20:47:24.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/faq/troubleshooting/
  md: https://developers.cloudflare.com/cloudflare-one/faq/troubleshooting/index.md
---

[❮ Back to FAQ](https://developers.cloudflare.com/cloudflare-one/faq/)

## I tried to register the WARP client with my Zero Trust domain but received the following error messages: `Authentication Expired` and `Registration error. Please try again later`.

When a user logs into an organization, WARP will open a web page so the user can sign in via Cloudflare Access. Access then generates a JSON Web Token (JWT) that is passed from the web page to the WARP client to authenticate the device. This JWT has a timestamp indicating the exact time it was created, as well as a timestamp indicating it will expire 50 seconds into the future.

This error message means that when the JWT is finally passed to the WARP client, it has already expired. One of two things can be happening:

1. (Most likely): Your computer system clock is not properly synced using Network Time Protocol (NTP). Visit <https://time.is> on the affected machine to validate your clock is properly synchronized within 20 seconds of the actual time.

2. You are waiting more than one minute to open Cloudflare WARP from the time Cloudflare Access prompts you. Open the WARP client as soon as you get the prompt.

## I see a website is blocked, and it shouldn't be.

If you believe a domain has been incorrectly blocked, you can use [this form](https://radar.cloudflare.com/categorization-feedback/) to get the URL reviewed.

## I see an error saying `No Access-Control-Allow-Origin header is present on the requested resource`.

Cloudflare Access requires that the credentials: `same-origin parameter` be added to JavaScript when using the Fetch API (to include cookies). AJAX requests fail without this parameter present. For more information, refer to our documentation about [CORS settings](https://developers.cloudflare.com/cloudflare-one/access-controls/applications/http-apps/authorization-cookie/cors/).

## I see untrusted certificate warnings for every page and I am unable to browse the Internet.

Advanced security features including HTTPS traffic inspection require users to install and trust the Cloudflare root certificate on their machine or device. If you are installing certificates manually on all of your devices, these steps will need to be performed on each new device that is to be subject to HTTP Filtering. To install the Cloudflare root certificate, follow [this guide](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/user-side-certificates/).

## I see error 526 when browsing to a website.

Gateway presents an **HTTP Response Code: 526** error page in the following cases:

* **An untrusted certificate is presented from the origin to Gateway.** Gateway will consider a certificate is untrusted if any of these conditions are true:

  * The server certificate issuer is unknown or is not trusted by the service.
  * The server certificate is revoked and fails a CRL check.
  * There is at least one expired certificate in the certificate chain for the server certificate.
  * The common name on the certificate does not match the URL you are trying to reach.
  * The common name on the certificate contains invalid characters (such as underscores). Gateway uses [BoringSSL](https://csrc.nist.gov/projects/cryptographic-module-validation-program/validated-modules/search?SearchMode=Basic\&Vendor=Google\&CertificateStatus=Active\&ValidationYear=0) to validate certificates. Chrome's [validation logic](https://chromium.googlesource.com/chromium/src/+/refs/heads/main/net/cert/x509_certificate.cc#429) allows non-RFC 1305 compliant certificates, which is why the website may load when you turn off WARP.

* **The connection from Gateway to the origin is insecure.** Gateway does not trust origins which:

  * Only offer insecure cipher suites (such as RC4, RC4-MD5, or 3DES). You can use the [SSL Server Test tool](https://www.ssllabs.com/ssltest/index.html) to check which ciphers are supported by the origin.
  * Do not support [FIPS-compliant ciphers](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/tls-decryption/#cipher-suites) (if you have enabled [FIPS compliance mode](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/tls-decryption/#fips-compliance)). In order to load the page, you can either disable FIPS mode or create a Do Not Inspect policy for this host (which has the effect of disabling FIPS compliance for this origin).
  * Redirect all HTTPS requests to HTTP.

If none of the above scenarios apply, contact Cloudflare support with the following information:

* Operating System (Windows 10, macOS 10.x, iOS 14.x)
* Web browser (Chrome, Firefox, Safari, Edge)
* URL of the request
* Screenshot or copy/paste of the content from the error page

For more troubleshooting information, refer to [Support](https://developers.cloudflare.com/support/troubleshooting/http-status-codes/cloudflare-5xx-errors/error-526/).

## I see an error in the Gateway Overview page, and no analytics are displayed.

![An error displayed in the Gateway Overview page instead of analytics.](https://developers.cloudflare.com/_astro/gateway-dash-overview-empty.DeSvdK_m_svMSL.webp)

You may not see analytics on the Overview page for the following reasons:

* **You are not sending DNS queries to Gateway**. Verify that the destination IP addresses you are sending DNS queries to are correct. You can check the destination IP addresses for your DNS location by going to **Gateway** > **DNS locations** and then expanding the location.
* **You are using other DNS resolvers**. If you have other DNS resolvers in your DNS settings, your device could be using IP addresses for resolvers that are not part of Gateway. Make sure to remove all other IP addresses from your DNS settings and only include Gateway's DNS resolver IP addresses.
* **The source IPv4 address for your DNS location is incorrect**. If you are using IPv4, check the source IPv4 address that you entered for the DNS location matches with the network's source IPv4 address.
* **Analytics is not available yet**. It takes some time to generate the analytics for Cloudflare Gateway. If you are not seeing anything even after 5 minutes, file a support ticket.

## I see a "No Browsers Available" alert.

If you encounter this error, [file feedback](https://developers.cloudflare.com/cloudflare-one/remote-browser-isolation/known-limitations/) via the WARP client and we will investigate.

## I see a "Maximum Sessions Reached" alert.

This can occur if your device is attempting to establish a connection to more than two remote browser instances. A browser isolation session is a connection from your local browser to a remote browser. Tabs and windows within the same browser share a single remote browser session. In practice, this generally means that you can open both Chrome and Firefox to use browser isolation concurrently, but attempting to open a third browser such as Opera will cause this alert to appear. To release a browser session, close all tabs/windows in your local browser. The remote browser session will be automatically terminated within 15 minutes.

## I see `SAML Verify: Invalid SAML response, SAML Verify: No certificate selected to verify` when testing a SAML identity provider.

This error occurs when the identity provider has not included the signing public key in the SAML response. While not required by the SAML 2.0 specification, Cloudflare Access always checks that the public key provided matches the **Signing certificate** uploaded to Zero Trust. For the integration to work, you will need to configure your identity provider to add the public key.

## I see `Error 0: Bad Request. Please create a ca for application.` when attempting to connect to SSH with a short-lived certificate.

This error will appear if a certificate has not been generated for the Access application users are attempting to connect to. For more information on how to generate a certificate for the application on the Access Service Auth SSH page, refer to [these instructions](https://developers.cloudflare.com/cloudflare-one/access-controls/applications/non-http/short-lived-certificates-legacy/).

## Mobile applications warn of an invalid certificate, even though I installed a Cloudflare certificate on my system.

These mobile applications may use certificate pinning Cloudflare Gateway dynamically generates a certificate for all encrypted connections in order to inspect the content of HTTP traffic. This certificate will not match the expected certificate by applications that use certificate pinning. To allow these applications to function normally, administrators can configure bypass rules to exempt traffic to hosts associated with the application from being intercepted and inspected.

## Firefox shows a network protocol violation when I use the WARP client.

If you see this warning, you may have to disable DNS over HTTPS setting in Firefox. If you need help doing that, see [these instructions](https://support.mozilla.org/en-US/kb/firefox-dns-over-https#w_manually-enabling-and-disabling-dns-over-https).

## Chrome shows `NET::ERR_CERT_AUTHORITY_INVALID` when I use the WARP client.

Advanced security features including HTTPS traffic inspection require you to deploy a [root certificate](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/user-side-certificates/) on the device. If [**Install CA to system certificate store**](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/user-side-certificates/automated-deployment/) is enabled, the WARP client will automatically install a new root certificate whenever you install or update WARP.

Certain web browsers (such as Chrome and Microsoft Edge) load and cache root certificates when they start. Therefore, if you install a root certificate while the browser is already running, the browser may not detect the new certificate. To resolve the error, restart the browser.

## I see `Access api error auth_domain_cannot_be_updated_dash_sso`.

This error appears if you try to change your [team domain](https://developers.cloudflare.com/cloudflare-one/faq/getting-started-faq/#whats-a-team-domainteam-name) while the [Cloudflare dashboard SSO](https://developers.cloudflare.com/fundamentals/manage-members/dashboard-sso/) feature is enabled on your account. Cloudflare dashboard SSO does not currently support team domain changes. Contact your account team for more details.

## WARP on Linux shows `DNS connectivity check failed`.

This error means that the `systemd-resolved` service on Linux is not allowing WARP to resolve DNS requests. You can identify this issue in the [`daemon.log`](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/troubleshooting/warp-logs/#warp-diag-logs) file of the `warp diag` logs, where the error message appears as `ERROR main_loop: warp::warp::connectivity_check: DNS connectivity check failed to resolve host="warp-svc."`.

To solve the issue:

1. Add the following line to `/etc/systemd/resolved.conf`:

```txt
ResolveUnicastSingleLabel=yes
```

1. Make sure that no other DNS servers are configured in `/etc/systemd/resolved.conf`. For example, if the file contains `DNS=X.Y.Z.Q`, comment out the line.

2. Restart the service:

```sh
sudo systemctl restart systemd-resolved.service
```

## Windows incorrectly shows `No Internet access` when WARP is enabled.

[NCSI](https://learn.microsoft.com/en-us/windows-server/networking/ncsi/ncsi-overview) is a Windows feature for determining network quality and connectivity. When WARP is enabled, NCSI checks can sometimes fail and cause a cosmetic UI error where the user believes they have no Internet even though the device still has full connectivity. Some apps (Outlook, JumpCloud) may refuse to connect because Windows is reporting there is no Internet connectivity.

To resolve the issue, you will need to edit two Windows registry keys:

1. Configure NCSI to detect WARP's [local DNS proxy](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/warp-architecture/#dns-traffic).

   ```txt
   HKEY_LOCAL_MACHINE\SOFTWARE\POLICIES\MICROSOFT\Windows\NetworkConnectivityStatusIndicator
   Type: DWORD
   Value: UseGlobalDNS
   Data: 1
   ```

2. Configure NCSI to use active probing mode, as WARP may be obscuring the number of hops expected by the [passive probe](https://learn.microsoft.com/en-us/windows-server/networking/ncsi/ncsi-frequently-asked-questions#how-does-passive-probing-determine-connectivity).

   ```txt
   HKEY_LOCAL_MACHINE\SYSTEM\CurrentControlSet\Services\NlaSvc\Parameters\Internet
   Type: DWORD
   Value: EnableActiveProbing
   Data: 1
   ```

If you continue to have issues with Microsoft 365 applications, consider enabling [**Directly route Microsoft 365 traffic**](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#directly-route-microsoft-365-traffic).

## I see `WebGL Rendering Error`.

Cloudflare Browser Isolation leverages Network Vector Rendering (NVR) technology. This allows us to deliver a secure, performant remote computing experience without the bandwidth limitations of traditional solutions. While we expect most websites to work perfectly, some browser features and web technologies such as WebGL (Web Graphics Library) are unsupported.

WebGL is a JavaScript API for rendering high-performance interactive 2D and 3D graphics within any compatible web browser without the use of plug-ins. Support for WebGL is present in all modern browsers. However, the user's device must also have access to the underlying [hardware](https://developer.mozilla.org/en-US/docs/Web/API/WebGL_API#browser_compatibility) that supports these features.

When running remote browser isolation in a virtualized environment, the user's device may not have access to the required system resources. To resolve the error, you can configure your browser to render vector graphics entirely through software, without using the hardware acceleration provided by a GPU.

To enable software rasterization:

1. Go to `chrome://flags/#override-software-rendering-list`.
2. Set **Override software rendering list** to *Enabled*.
3. Select **Relaunch** to apply the change.

## I cannot send emails on port `25`.

By default, the WARP client blocks outgoing SMTP traffic on port `25` to prevent users from abusing our service to send spam. Modern email service providers use port `587` or `465` to encrypt emails over a TLS/SSL connection. For more information, refer to [What SMTP port should be used?](https://www.cloudflare.com/learning/email-security/smtp-port-25-587/).

If you need to unblock port `25`, contact your account team.

## I see `502 Bad Gateway` when browsing to a website.

This issue can occur when communicating with an origin that partially supports HTTP/2. In these scenarios, the connection from Gateway to the website starts using HTTP/2 but requests a downgrade to HTTP/1.1 for some requests. For example, servers such as [Microsoft Internet Information Services (IIS)](https://learn.microsoft.com/iis/get-started/whats-new-in-iis-10/http2-on-iis#when-is-http2-not-supported) do not support authentication over HTTP/2. When errors occur, the website may send back a `RST_STREAM` frame with the error code `HTTP_1_1_REQUIRED`, which indicates that the browser should retry the request over HTTP/1.1. Gateway translates any received upstream `RST_STREAM` frames to a pseudo socket close, so this appears as a `502 Bad Gateway` exception page. The browser will not indicate why it failed.

Gateway does not support this downgrade mechanism. When receiving the `HTTP_1_1_REQUIRED` error code, Gateway will not reissue requests over HTTP/1.1. To make the connection from Gateway to the website successfully, you will need to disable HTTP/2 at the origin.

## I see `This site can't provide a secure connection.`

If you see an error with the title `This site can't provide a secure connection` and a subtitle of `<hostname> uses an unsupported protocol`, you must [order an Advanced Certificate](https://developers.cloudflare.com/ssl/edge-certificates/advanced-certificate-manager/manage-certificates/#create-a-certificate).

If you added a [multi-level subdomain](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/get-started/create-remote-tunnel/#2a-connect-an-application) (more than one level of subdomain), you must [order an Advanced Certificate for the hostname](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/get-started/create-remote-tunnel/#2a-connect-an-application) as Cloudflare's Universal certificate will not cover the public hostname by default.

## As of February 2, 2025, my end-user device's browser is returning a `Your connection is not private` warning.

### Why am I getting this error?

The default global Cloudflare root certificate expired on 2025-02-02 at 16:05 UTC. If you installed the default Cloudflare certificate before 2024-10-17, you must [generate a new certificate](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/user-side-certificates/#generate-a-cloudflare-root-certificate) and activate it for your Zero Trust organization to avoid inspection errors. If you did not generate a new certificate before February 2, 2025, you will encounter browser warnings like `Your connection is not private`.

Starting with WARP client version 2024.12.554.0 and later, the WARP client will automatically install Cloudflare certificates in an end-user device's certificate store as soon as the Cloudflare certificates appear as **Available** in the Cloudflare dashboard.

For WARP client versions prior to 2024.12.554.0, certificates had to be marked as **In-Use** in the Cloudflare dashboard before the WARP client could push the Cloudflare certificates to an end-user device's certificate store.

### What do I need to do?

Before deploying a new certificate, [update WARP](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/update-warp/#how-to-update-warp) to version 2024.12.554.0 or newer.

For WARP client versions before and after 2024.12.554.0, certificate propagation will only occur when the WARP client is responsible for automatically installing the certificate on the client device. To enable the WARP client to propogate certificates:

1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **Settings** > **WARP Client**.
2. Turn on **Install CA to system certificate store**.

If **Install CA to system certificate store** is turned off, you must [manually install the certificate](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/user-side-certificates/manual-deployment/), use an [MDM solution](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/user-side-certificates/manual-deployment/#mobile-device-management-mdm-software) to distribute the Cloudflare certificate to your fleet of devices, or not use the Cloudflare certificate because you do not want to have TLS decryption enabled. [TLS decryption](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/tls-decryption/) must be enabled to enforce Gateway HTTP policies for HTTPS traffic.

After enabling certificate propagation, you must update your certificate:

1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **Settings** > **Resources**, then select **Manage** next to **Cloudflare certificates**.
2. Select **Generate certificate**.
3. Select the expiration date for this new certificate (five years is the default, but this can be adjusted) and select **Generate certificate**.
4. The new certificate will be marked **Inactive** at first. Select the **three dots** to the right of the certificate, then select **Activate** to activate the certificate.

For WARP versions on or above 2024.12.554.0, selecting **Activate** will download the new certificate to end-user devices.

Certificate propagation to end-user devices can take up to 10 minutes, but can be expedited by resetting the encryption keys.

To reset the encryption keys:

1. Open the WARP GUI on your device.
2. Select the gear icon on the top right > **Preferences**.
3. Select **Connection**, then select **Reset Encryption Keys**.

macOS Big Sur and newer releases do not allow WARP to automatically trust the certificate. You must either [manually trust the certificate](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/user-side-certificates/automated-deployment/#macos) as the user or [use a MDM to trust the certificate](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/user-side-certificates/manual-deployment/#mobile-device-management-mdm-software).

After confirming that the certificate is installed and trusted on the end-user device, mark the certificate as **In-Use**. To mark the certificate as **In-Use**:

1. In [Zero Trust](https://one.dash.cloudflare.com/), go to **Settings** > **Resources**, then select **Manage** next to **Cloudflare certificates**.
2. Select a certificate.
3. In the detailed menu under **Basic Information**, select **Confirm and turn on certificate**.
4. Once turned on, the new certificate will now show as **In-Use** in Zero Trust. **In-Use** indicates that the certificate is being used for inspection.

It is recommended to have end users disconnect and reconnect WARP to expedite this change being reflected on their local machine. To verify the new certificate is being used correctly:

1. Connect to WARP.
2. Visit an HTTPS site.
3. Verify that no certificate error is enountered.

Additionally, you can check the certificate used within your browser by viewing the certificate (steps vary by browser, but you can generally do this check by selecting the lock icon next to the URL) and verifying the Organizational Unit (OU) does not reference `ECC Certificate Authority`.

The new certificate will be valid until the configured expiration date.

### I followed all the instructions but I am still having problems with my certificate.

If the new certificate is not activating on the end-user device or you are getting a `Certificate is missing` warning even though the certificate is marked **In-Use**. Refer to the following troubleshooting options:

1. Rotate the keys used by WARP to force activate the new certificate by running:

   ```sh
   warp-cli tunnel rotate-keys
   ```

2. [Upgrade](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/update-warp/#how-to-update-warp) to WARP version 2024.12.554.0.

   Some customers who are on versions earlier than 2024.11.309.0 have experienced inconsistencies with certificate installation and may need to upgrade.

3. Turn off TLS Decryption.

If no measure is working quickly and you are encountering browser warnings that are blocking work, [turning off TLS decryption](https://developers.cloudflare.com/cloudflare-one/traffic-policies/http-policies/tls-decryption/#turn-on-tls-decryption) will prevent HTTP policies from being enforced and will ensure websites resolve until the certificate can be deployed to more user devices.

Turning off TLS decryption should be a temporary measure. TLS decryption should be turned on if you need to enforce HTTP policies and log traffic for HTTPS traffic.

## I am getting an `Error 401: deleted_client - The OAuth Client was deleted` authorization error.

If you deleted the OAuth client (or the OAuth client expired) in Google, you will receive a `Error 401: deleted_client` authorization error.

To fix this issue, complete steps 6 through 12 in the [Google](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/google/#set-up-google-as-an-identity-provider) guide and steps 9 through 15 in the [Google Workspace](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/google/#set-up-google-as-an-identity-provider) guide.

## I entered an override code for WARP that was supposed to be valid for 3 hours but the override code expired faster than I expected.

[Admin override](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#admin-override) codes are time-sensitive and adhere to fixed-hour time blocks. Override codes can be reused until the end of their timeout. An override code's timeout begins in the hour the override code was generated in. Refer to the following scenarios.

### Scenario one: Admin generates an override code at 9:00 AM with a timeout of one hour.

If admin generates an override code with a timeout of one hour at **9:00 AM** and the user inputs the override code in their device at **9:59 AM**, the user will be able to toggle WARP on and off until **10:59 AM** (a one hour duration.)

However, if the user attempts to enter the override code at **10:00 AM**, the override code will not work. The override code will not work because the override code was generated at **9:00 AM** and its one hour validity was counted as used in the 9:00 AM to 10:00 AM hour.

### Scenario two: Admin generates an override code at 9:30 AM with timeout of three hours.

If admin generates an override code with a timeout of three hours at **9:30 AM** and the user inputs the override code in their device at **9:59 AM**, the user will be able to toggle WARP on and off until **12:59 PM** (a three hour duration.)

However, if the user attempts to enter the override code at **10:00 AM**, the override code will only be valid until **12:00 PM** (a two hour duration). The override code was generated at **9:30 AM** and one hour of its total three hour validity was counted as used in the 9:00 AM to 10:00 AM hour.

### Scenario three: Admin generates an override code at 12:30 PM with a timeout of 24 hours.

If admin generates an override code with a timeout of 24 hours at **12:30 PM** and the user inputs the override code in their device at **12:59 PM** the same day, the user will be able to toggle WARP on and off until **12:59 PM** the next day (a 24 hour duration.)

However, if the user attempts to enter the override code at **1:00 PM** the same day, the override code will only be valid until **11:00 AM** the next day (a 23 hour duration). The override code was generated at **12:30 PM** and one hour of its total 24 hour validity was counted as used in the 12:00 PM to 1:00 PM hour.

If the user attempts to enter the override code at **11:59 AM** the next day, the override code will only be valid until **12:59 PM** (a one hour duration). The override code was generated at **12:00 PM** and 23 hours of its total 24 hour validity were counted as used from 12:00 PM to 11:00 AM the next day (a 23 hour duration).

## I disabled WARP using an override code but WARP turned on by itself before my override code expired.

If you are using an [Admin override](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#admin-override) code with [Auto connect](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#auto-connect) also enabled, WARP will turn on automatically according to the Timeout set for **Auto connect**. Using an override code to override the WARP lock switch will not disable Auto connect. As best practice, review your Auto connect settings before sending the override code to the user.

To prevent WARP from auto connecting while using an admin override code, disable Auto connect or set a longer **Timeout** for **Auto connect**. Note the changes you make to Auto connect while the end user is using the admin override code if you need to revert these changes later.

## I am getting the error `Failed to fetch user/group information from the identity provider`.

This error is returned when proper API permissions are not set up in the identity provider. When Cloudflare attempts to fetch user/group information from the identity provider and proper API permissions have not been configured, the `Failed to fetch user/group information from the identity provider` error will appear. Review the [SSO integration](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/) guide for your identity provider to ensure your application has the appropriate API permissions.

For example, [Microsoft Entra](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/entra-id/#2-configure-api-permissions-in-entra-id) and [Okta](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/okta/#:~:text=\(Optional\)%20Create%20an%20Okta%20API%20token%20and%20enter%20it%20in%20Zero%20Trust%20\(the%20token%20can%20be%20read%2Donly\).%20This%20will%20prevent%20your%20Okta%20groups%20from%20failing%20if%20you%20have%20more%20than%20100%20groups) have required permissions stated in their integration guides.

You can also examine logs in your identity provider to identify any denied requests related to API access.

## WSL2 is losing connectivity when using WARP.

If your WSL2 environment is losing connectivity while using WARP, check your [split tunnel configuration](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/split-tunnels/).

The issue may arise because the IP range that the WSL environment uses to communicate with the host device is included in the split tunnel configuration. Excluding the WSL environment’s IP range should restore connectivity.

You must ensure the host device is included in the WARP tunnel while excluding the WSL environment to prevent connectivity issues between WSL and the host device.

To debug this issue:

1. Review the WSL2 environment's IP address and compare it with the laptop’s IP.
2. Check if the WSL network is [included in the split tunnel configuration](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/route-traffic/split-tunnels/#change-split-tunnels-mode).
3. If the WSL network is included, exclude it from the split tunnel to prevent connectivity issues.

## Clientless Web Isolation is loading with a blank screen on a Windows device.

This issue can occur due to a conflict between browser settings and Windows network configuration.

In Chromium-based browsers like Chrome and Edge, the **Anonymize local IPs exposed by WebRTC** flag (`chrome://flags/#enable-webrtc-hide-local-ips-with-mdns` or `edge://flags/#enable-webrtc-hide-local-ips-with-mdns`) — when set to `Enabled` or left at `Default` — hides local IP addresses by replacing them with mDNS hostnames. Multicast DNS (mDNS) hostnames rely on multicast traffic to be resolved properly on the local network.

The [Internet Group Management Protocol (IGMP)](https://www.cloudflare.com/learning/network-layer/what-is-igmp/) allows devices to join a multicasting group. On Windows, `IGMPLevel` determines whether the system participates in multicast group membership. When `IGMPLevel` is set to `0`, multicast support is disabled.

To resolve this error, review the following options:

| `IGMPLevel` | **Anonymize local IPs exposed by WebRTC** setting | Result in Clientless Web Isolation |
| - | - | - |
| `0` (disabled) | **Enabled / Default** | ❌ Blank screen |
| `0` (disabled) | **Disabled** | ✅ Works - browser will use local IP address |
| `2` (enabled) | **Enabled / Default** | ✅ Works - mDNS resolves successfully |

## After putting Google Workspace behind Access, I can’t log in. It keeps redirecting between Access and Google without ever completing authentication.

When you put your Google Workspace behind Access, users will not be able to log in using Google or Google Workspace as an identity provider.

This configuration creates an authentication loop. Cloudflare Access tries to authenticate the user via Google, but Google itself treats Cloudflare as its identity provider and requires authentication from Cloudflare. Since each system depends on the other to complete login first, the user is caught in an infinite redirect cycle and can never successfully authenticate.

## When installing WARP on Windows, the Setup Wizard ends prematurely.

This error can occur for several reasons, including missing dependencies, like the appropriate .NET Framework version or other Dynamic Link Libraries (DLLs) such as `netstandard2.0`, required during installation.

To investigate, run the following command to generate installation logs:

```powershell
msiexec /i <PATH_TO_WARP_MSI> /L*V <PATH_TO_OUTPUT_LOG>
```

Check the logs to verify if there are any missing DLLs (for example, `netstandard2.0`), which may point to a missing or outdated version of the .NET Framework.

One common cause is a missing or outdated version of the [.NET Framework Runtime](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/download-warp/#windows:~:text=NET%20Framework%20version-,4.7.2%20or%20later,-HD%20space). Cloudflare WARP requires a .NET Framework version of `4.7.2` or later.

Some legacy Windows systems (such as Windows 10 Enterprise 1607 LTSB, which is bundled with .NET `4.6`) do not include this runtime by default and may fail during installation with a `Setup Wizard ended prematurely` error. More recent Windows versions include .NET `4.7.2` or later by default and do not encounter this error.

To fix this:

1. Download and install the [.NET Framework 4.7.2 Runtime](https://dotnet.microsoft.com/en-us/download/dotnet-framework/net472) (make sure to install the **Runtime**, not the Developer Pack).
2. Re-run the WARP installer.

If the problem continues, try running the [.NET Repair Tool](https://www.microsoft.com/en-ca/download/details.aspx?id=30135), or check which .NET versions are installed by running the following command in PowerShell:

```powershell
Get-ChildItem -Path "HKLM:\SOFTWARE\Microsoft\NET Framework Setup\NDP" -Recurse | ForEach-Object { $_.Name; Get-ItemProperty $_.PSPath; "" }
```

## I get an `Invalid session. Please try logging in again.` error from Access when trying to log in to the Cloudflare dashboard via SSO.

Cloudflare Access uses a [`CF_Session` cookie](https://developers.cloudflare.com/cloudflare-one/access-controls/applications/http-apps/authorization-cookie/#access-cookies) to validate that the same browser both initiated and completed your sign-in. The `Invalid session` error means Access was unable to validate this cookie. Ensure that there is no software or firewall on your device or network that may be interfering with requests to Access.

## Long-lived SSH sessions frequently disconnect.

All connections proxied through Cloudflare Gateway, including traffic to [Access for Infrastructure](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/use-cases/ssh/ssh-infrastructure-access/) SSH targets, have a maximum guaranteed duration of 10 hours. It is possible for connections to last longer than 10 hours. However, if a connection is active at the time of a Gateway release, Gateway will terminate the connection 10 hours later. Releases are not scheduled and can occur multiple times a week.

To prevent long-lived SSH connections from breaking unexpectedly, we recommend terminating sessions on a predefined schedule. For example, you could set an 8-hour idle timeout so that inactive sessions automatically disconnect during off hours. To configure an idle timeout, add the `ChannelTimeout` option to either the SSH server (`/etc/ssh/sshd_config`) or client configuration file (`~/.ssh/config`):

```txt
ChannelTimeout global=8h
```

Implementing [`ChannelTimeout` on the client side](https://man.openbsd.org/ssh_config#ChannelTimeout) allows users to choose a time that works for them, whereas implementing it on the [server side](https://man.openbsd.org/sshd_config#ChannelTimeout) removes the configuration burden from the end user.
